package com.company.model;

public class School {
    private String name;
    private SubjectContainer subjects;
    private StudentContainer students;
    private InstructorContainer instructors;
    private EnrollContainer enrolls;
    private void setDataForConsistency(){
        this.students.setEnrolls(this.enrolls);
        this.subjects.setEnrolls(this.enrolls);
        this.subjects.setInstructors(this.instructors);
    }

    public School(String name) {
        this.name = name;
        this.subjects = new SubjectContainer();
        this.students = new StudentContainer();
        this.instructors = new InstructorContainer();
        this.enrolls = new EnrollContainer();
        setDataForConsistency();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SubjectContainer getSubjectContainer() {
        return subjects;
    }

    public StudentContainer getStudentContainer() {
        return students;
    }

    public InstructorContainer getInstructorContainer() {
        return instructors;
    }

    public EnrollContainer getEnrollContainer() {
        return enrolls;
    }
}
